#include "JabberMeetingAccountCupSync.h"
#include "../MeetingServiceImpl.h"
#include "../JabberServiceProvider.h"
#include "jcfcoreutils/EncryptionUtils.h"
#include "csf/Base64.hpp"

namespace CSFUnified
{
    using namespace std;
    
	static CSFLogger* logger = CSFLogger_getLogger("MeetingService-JabberMeetingAccountCupSync");

    JabberMeetingAccountCupSync::JabberMeetingAccountCupSync(IJabberMeetingAccountEvent * pEvent) : m_event(*pEvent)
    {
    }
    
    JabberMeetingAccountCupSync::~JabberMeetingAccountCupSync()
    {

    }
    
    void JabberMeetingAccountCupSync::start()
    {
        reset();
    }
    
    void JabberMeetingAccountCupSync::stop()
    {
        reset();
    }
    
    void JabberMeetingAccountCupSync::syncAllSite()
    {
        std::string defaultSite;
        std::list<SMART_PTR_NS::shared_ptr<MeetingSiteImpl> > siteList;
        loadServerSite(siteList);
        loadLocalSite(siteList, defaultSite);

        if (defaultSite.length() > 0)
        {
            std::list<SMART_PTR_NS::shared_ptr<MeetingSiteImpl> >::iterator it = siteList.begin();
            
            while (it != siteList.end())
            {
                if (defaultSite == (*it)->getSiteUrl())
                {
                    m_defaultSite = (*it);
                    break;
                }
                
                it++;
            }
        }
        else
        {
            if (siteList.size() > 0)
            {
                m_defaultSite = siteList.front();
            }
            else
            {
                m_defaultSite.reset();
            }
        }

        m_event.onGetAllSite(true, siteList);
    }
    
    void JabberMeetingAccountCupSync::getDefaultSite()
    {
		m_event.onGetDefaultSite(e_jmaec_success, "", m_defaultSite, "", 0);
    }
    
    void JabberMeetingAccountCupSync::setDefaultSite(SMART_PTR_NS::shared_ptr<MeetingSiteImpl> site, std::string sessionTicket, long keepAliveTime)
    {
		if (1 == site->getSSOFlag() && "" == sessionTicket)
		{
			m_event.onSetDefaultSite(e_jmaec_error_setup_error, "", site, sessionTicket, keepAliveTime);
		}
		else
		{
			m_event.onSetDefaultSite(e_jmaec_success, "", site, sessionTicket, keepAliveTime);
		}
    }
    
    void JabberMeetingAccountCupSync::deleteSite(std::string siteUrl)
    {
    }
    
    void JabberMeetingAccountCupSync::updateAllSite(std::string defaultSiteUrl, MeetingSiteImpl* addedSite, std::string deletedSiteUrl)
    {
		if (NULL != addedSite)
        {
			m_defaultSite.reset(new MeetingSiteImpl(addedSite));

            if (addedSite->getDeletableFlag())
            {
				addSiteToList(addedSite->getSiteUrl());
            }
            else if (1 != addedSite->getSSOFlag())
            {
                JabberServiceProvider::getInstance().setMeetingCredential(addedSite->getUserName(), addedSite->getPassword());
            }
		}
        else if (deletedSiteUrl.length() > 0)
        {
			if (NULL != m_defaultSite.get() && deletedSiteUrl == m_defaultSite->getSiteUrl())
			{
				m_defaultSite.reset();
			}
			delSiteFromList(deletedSiteUrl);
        }

		saveSiteInfomation(m_defaultSite.get());
    }

	void JabberMeetingAccountCupSync::reset()
    {
        m_defaultSite.reset();
        m_locatSite.reset();
        m_localSiteList.clear();
    }
    
    void JabberMeetingAccountCupSync::loadServerSite(std::list<SMART_PTR_NS::shared_ptr<MeetingSiteImpl> >& siteList)
    {
		CSFLogInfoS(logger, "Load server site ");
        JabberServiceProvider& provider = JabberServiceProvider::getInstance();
        std::string siteId = provider.getConfigValueByKey("meeting_server_address");
        std::string siteIdBackup = provider.getConfigValueByKey("meeting_server_address_backup");
        std::string siteIdBackup2 = provider.getConfigValueByKey("meeting_server_address_backup2");
        SMART_PTR_NS::shared_ptr<Credentials> cred = provider.getMeetingCredential();
        
        if (NULL == cred.get())
        {
            return;
        }

        if (siteId.length() > 0)
        {
            SMART_PTR_NS::shared_ptr<MeetingSiteImpl> site;

            site.reset(new MeetingSiteImpl());
            site->setSiteUrl(siteId);
            site->setSiteDescription("");
            site->setUserName(cred->getUsername());
            site->setPassword(cred->getSecurePassword());
            site->setEditableFlag(cred->getIsEditable());
            site->setDeletableFlag(false);
            site->setDefaultSiteFlag(true);
            site->setActiveFlag(false);
            site->setSiteFlag(0);
            site->setSSOFlag(2);
            
            m_defaultSite = site;
            siteList.push_back(site);
        }
        
        if (siteIdBackup.length() > 0)
        {
            SMART_PTR_NS::shared_ptr<MeetingSiteImpl> site;
            
            site.reset(new MeetingSiteImpl());
            site->setSiteUrl(siteIdBackup);
            site->setSiteDescription("");
            site->setUserName(cred->getUsername());
            site->setPassword(cred->getSecurePassword());
            site->setEditableFlag(cred->getIsEditable());
            site->setDeletableFlag(false);
            site->setDefaultSiteFlag(true);
            site->setActiveFlag(false);
            site->setSiteFlag(0);
            site->setSSOFlag(2);

            siteList.push_back(site);
        }

        if (siteIdBackup2.length() > 0)
        {
            SMART_PTR_NS::shared_ptr<MeetingSiteImpl> site;
            
            site.reset(new MeetingSiteImpl());
            site->setSiteUrl(siteIdBackup2);
            site->setSiteDescription("");
            site->setUserName(cred->getUsername());
            site->setPassword(cred->getSecurePassword());
            site->setEditableFlag(cred->getIsEditable());
            site->setDeletableFlag(false);
            site->setDefaultSiteFlag(true);
            site->setActiveFlag(false);
            site->setSiteFlag(0);
            site->setSSOFlag(2);
            
            siteList.push_back(site);
        }
    }
    
    void JabberMeetingAccountCupSync::loadLocalSite(std::list<SMART_PTR_NS::shared_ptr<MeetingSiteImpl> >& siteList, std::string& defaultSite)
    {        
        JabberServiceProvider& provider = JabberServiceProvider::getInstance();

        defaultSite = provider.getConfigValueByKey("meeting_service_default_site_url");
        std::string siteUrl = provider.getConfigValueByKey("meeting_service_local_meeting_site_url");
		std::string siteUrl_backup = provider.getConfigValueByKey("meeting_service_local_meeting_site_url_backup");
		std::string siteUrl_backup2 = provider.getConfigValueByKey("meeting_service_local_meeting_site_url_backup2");
		std::string userName = "";
		csf::SecureString password;

		CSFLogInfoS(logger, "Load local site defaultSite: " << defaultSite << " siteUrl:" << siteUrl);

		bool isLocal = (siteUrl == defaultSite) ? true : false;
		if (isLocal)
		{
			SMART_PTR_NS::shared_ptr<Credentials> cred = provider.getCustomizedMeetingCredential();
			if (NULL != cred.get())
			{
				userName = cred->getUsername();
				password = cred->getSecurePassword();
			}
		}
        
		m_locatSite.reset();
		m_locatSite_backup.reset();
		m_locatSite_backup2.reset();
		m_localSiteList.clear();

		if (siteUrl.length() > 0)
		{
			m_locatSite.reset(new MeetingSiteImpl());
			m_locatSite->setSiteUrl(siteUrl);
			m_locatSite->setSiteDescription("");
			m_locatSite->setEditableFlag(true);
			m_locatSite->setDeletableFlag(true);
			m_locatSite->setDefaultSiteFlag(defaultSite == siteUrl ? true : false);
			m_locatSite->setActiveFlag(false);
			m_locatSite->setSiteFlag(0);
			m_locatSite->setSSOFlag(2);

			if (isLocal)
			{
				m_locatSite->setUserName(userName);
				m_locatSite->setPassword(password);
			}

			siteList.push_back(m_locatSite);
			m_localSiteList.push_back(siteUrl);
		}

		if (siteUrl_backup.length() > 0)
		{
			m_locatSite_backup.reset(new MeetingSiteImpl());
			m_locatSite_backup->setSiteUrl(siteUrl_backup);
			m_locatSite_backup->setSiteDescription("");
			m_locatSite_backup->setEditableFlag(true);
			m_locatSite_backup->setDeletableFlag(true);
			m_locatSite_backup->setDefaultSiteFlag(false);
			m_locatSite_backup->setActiveFlag(false);
			m_locatSite_backup->setSiteFlag(0);
			m_locatSite_backup->setSSOFlag(2);
			siteList.push_back(m_locatSite_backup);
			m_localSiteList.push_back(siteUrl_backup);
		}

		if (siteUrl_backup2.length() > 0)
		{
			m_locatSite_backup2.reset(new MeetingSiteImpl());
			m_locatSite_backup2->setSiteUrl(siteUrl_backup2);
			m_locatSite_backup2->setSiteDescription("");
			m_locatSite_backup2->setEditableFlag(true);
			m_locatSite_backup2->setDeletableFlag(true);
			m_locatSite_backup2->setDefaultSiteFlag(false);
			m_locatSite_backup2->setActiveFlag(false);
			m_locatSite_backup2->setSiteFlag(0);
			m_locatSite_backup2->setSSOFlag(2);
			siteList.push_back(m_locatSite_backup2);
			m_localSiteList.push_back(siteUrl_backup2);
		}
    }

	void JabberMeetingAccountCupSync::addSiteToList(std::string siteUrl)
	{
		std::list<std::string>::iterator it = m_localSiteList.begin();
		while (it != m_localSiteList.end())
		{
			if ((*it) == siteUrl)
			{
				return;
			}

			it++;
		}

		m_localSiteList.push_front(siteUrl);
	}

	void JabberMeetingAccountCupSync::delSiteFromList(std::string siteUrl)
	{
		std::list<std::string>::iterator it = m_localSiteList.begin();
		while (it != m_localSiteList.end())
		{
			if ((*it) == siteUrl)
			{
				m_localSiteList.erase(it);
				break;
			}

			it++;
		}
	}

	void JabberMeetingAccountCupSync::saveSiteInfomation(MeetingSiteImpl *pObj)
	{
		bool isLocal = false;
		bool isSSO = false;
		std::string defaultSiteUrl = "";
		std::string siteUrl = "";
		std::string siteUrl_backup = "";
		std::string siteUrl_backup2 = "";
		std::string userName = "";
		std::string userPass = "";
        std::string encrypt_pass = "";

		if (NULL != pObj)
		{
			isLocal = pObj->getDeletableFlag();
			isSSO = (1 == pObj->getSSOFlag()) ? true : false;
			defaultSiteUrl = pObj->getSiteUrl();
		}

		JabberServiceProvider& provider = JabberServiceProvider::getInstance();
		if (isLocal)
		{
			siteUrl = defaultSiteUrl;
			if (!isSSO)
			{
				provider.setCustomizedMeetingCredential(pObj->getUserName(), pObj->getPassword());
			}
		}

		std::list<std::string>::iterator it = m_localSiteList.begin();
		while (it != m_localSiteList.end())
		{
			std::string temp = (*it);
			if (temp != siteUrl)
			{
				if (siteUrl == "")
				{
					siteUrl = temp;
				}
				else if (siteUrl_backup == "")
				{
					siteUrl_backup = temp;
				}
				else if (siteUrl_backup2 == "")
				{
					siteUrl_backup2 = temp;
					break;
				}
			}

			it++;
		}

		provider.setConfigValueByKey("meeting_service_default_site_url", defaultSiteUrl);
		provider.setConfigValueByKey("meeting_service_local_meeting_site_url", siteUrl);
		provider.setConfigValueByKey("meeting_service_local_meeting_site_url_backup", siteUrl_backup);
		provider.setConfigValueByKey("meeting_service_local_meeting_site_url_backup2", siteUrl_backup2);
	}

}
